; LaunchPad v2.8x Key Generator
; By CrackZ (15/01/99).
;
; Use tasm /zi launchpd.asm and then tlink /v launchpd
; to generate launchpd.exe

.MODEL SMALL
.STACK 100h
.386

.DATA
input   DB 1Dh,0 ; Max 28 for name length
prompt  DB 'Input your Registration Name (min. 6 letters): ','$'
done	DB 'Your Registration Number is: ','$'
lf      DB 0ah,0dh,'$'
logo    DB 0ah,0dh, '-----------------------------------------',0ah,0dh
	DB          ' LaunchPad v2.8x Key Generator by CrackZ ',0ah,0dh
	DB          '-----------------------------------------',0ah,0dh
	DB 0ah,0dh,'$'

.CODE

START:	MOV AX,@DATA
	MOV DS,AX
	MOV ES,AX
	LEA EDX,[logo]
	MOV AH,09h
	INT 21h		;Display Logo.
	LEA EDX,[prompt]
	MOV AH,09h
	INT 21h		;Prompt.
	LEA EDX,[input]
	MOV AH,0Ah
	INT 21h		;Get registration name.
	LEA EDI,input+2	;Place name @ EDI.
        MOVZX EBX, BYTE PTR [EDI-1] ;Name length in EBX.
	CMP BX,6h ;Check its at least 6.
	JB endprg ;Too short, gracefully exit.
	JMP @inits ;Else prepare for calculation routine.

@inits:	XOR AX,AX
	XOR CX,CX ;Result store.
	XOR ESI,ESI ;Clear some registers.

@func1:	MOVSX EAX, BYTE PTR [EDI+ESI] ;Use ESI to control the loop.
	CALL upcase
	AND EDX,80000001h
	JNS @f1sub1
	CALL jns@no ;Call if signed flag wasn't set.

@f1sub1:
	TEST EDX,EDX
	JNZ @f1sub2
	ADD AX,2h
	ADD AX,AX
	LEA EAX, [EAX*4+EAX]
	JMP @f1sub2 ;Store it.

@f1sub2:
	ADD ECX,EAX ;ECX = store.
	INC SI ;Increment name position.
	CMP SI,BX
	JL @func1

;When this loop has completed the first result is stored in ECX, we'll then
;save that value on the stack.

	PUSH ECX ;Stack 1st result.
	XOR SI,SI ;Reset for 2nd loop.
	XOR CX,CX ;Reset store.

@func2:	MOVSX EAX, BYTE PTR [EDI+ESI]
	CALL upcase
	AND EDX,80000001h
	JNS @f2sub1
	CALL jns@no ;Call if signed flag wasn't set.

@f2sub1:TEST EDX,EDX
	JNZ @f2sub2
	JMP @f2ret

@f2sub2:ADD AX,2h
	ADD AX,AX
	LEA EAX, [EAX*4+EAX]

@f2ret:	ADD ECX,EAX
	INC SI
	CMP SI,BX
	JL @func2
	POP EAX	;Restore 1st result.
	MOV EDX,EAX ;Save 1st in EDX.
	MOV ESI,ECX ;Save 2nd in ESI.
	XOR BX,BX
	CMP EAX,ECX ;CMP dest,src
	JA @sub12 ;If 1st greater than 2nd.
	JB @sub21 ;Else 2nd greater than 1st.

@sub12:	SUB EAX,ECX
	MOV EBX,EAX
	MOV EAX,EDX ;Restore.
	JMP @3rdres

@sub21:	SUB ECX,EAX
	MOV EBX,ECX
	MOV ECX,ESI ;Restore.
	JMP @3rdres

;Now we have all of the good code we can start to output.
;EAX=1st part, EBX=3rd, ECX=2nd.

@3rdres:ADD BX,64h
	PUSH BX	;Save 3rd result on stack.
	XOR BX,BX
	XOR SI,SI ;Clear SI.
	PUSH CX	;2nd result.
	POP SI	;Now in SI.
	MOV CX,0Ah ;CX=10 dec.
	CALL @out0 ;Output 1st.
	ADD DI,AX ;Update position in DI.
	MOV BYTE PTR [EDI],2Dh ;Add the hyphen.
	INC DI	;Add 1 because of the hyphen.
	MOV AX,SI ;Restore 2nd.
	CALL @out0 ;Output 2nd.
	ADD DI,AX ;Add length of 2nd result to DI.
	MOV BYTE PTR [EDI],2Dh ;Add the hyphen.
	POP AX ;Restore 3rd.
	INC DI ;Add 1 because of hyphen.
	CALL @out0 ;Output 3rd.
	ADD DI,AX ;Add length of final result.
	MOV BYTE PTR [EDI],'$' ;Denote end of code.
	MOV DI,2h ;Point DI at start of good code.
	JMP final

@out0:	XOR EDX,EDX
	DIV ECX
	ADD EDX,30h
	PUSH EDX
	INC EBX
	TEST EAX,EAX
	JNZ @out0

@out1:	POP EDX
	MOV BYTE PTR [EDI+EAX],DL
	INC EAX
	TEST EBX,EBX
   	DEC EBX
	JNZ @out1
	RET

;Functions Section

upcase:	CMP AL,61h
	JL urtrn
	CMP AL,7Ah
	JG urtrn
	SUB AL,20h
	MOV DL,AL
	RET

urtrn:	MOV DL,AL
	RET 

jns@no:	DEC EDX
	OR EDX,0FFFFFFFEh
	INC EDX
	RET

final:	LEA EDX,[lf]
	MOV AH,09h
	INT 21h	;Linefeed.
	LEA EDX,[done]
	MOV AH,09h
	INT 21h
	LEA EDX,[EDI]
	MOV AH,09h
	INT 21h

endprg:	MOV AX,4C00h
	INT 21h

END START